<?php
/**
 * Plugin Name: Disable User Endpoints
 * Plugin URI:  https://wujie.me/
 * Description: A plugin to disable the user endpoints in the WordPress REST API.
 * Version:     1.0
 * Author:      慢读时光
 * Author URI:  https://wujie.me/
 * License:     GPL2
 */

// 禁用用户相关的 REST API 端点
add_filter('rest_endpoints', function ($endpoints) {
    // 检查当前用户是否已登录
	// 判断登录用来禁止直接从浏览器访问 /?rest_route=/wp/v2/users/、/wp-json/wp/v2/users/ 接口，而保证从网站后台能顺利调用这个接口
    if (!is_user_logged_in()) { 
        // 禁用用户相关的 REST API 端点
        if (isset($endpoints['/wp/v2/users'])) {
            unset($endpoints['/wp/v2/users']);
        }
        if (isset($endpoints['/wp/v2/users/(?P<id>[\d]+)'])) {
            unset($endpoints['/wp/v2/users/(?P<id>[\d]+)']);
        }
    }

    return $endpoints;
});
