<?php
/**
 * @package Hello_My_Dolly
 * @version 1.7.2
 */
/*
Plugin Name: Hello My Dolly
Plugin URI: 
Description: 根据 Hello Dolly 插件改的名言警句插件
Author: Modify by Wujie
Version: 1.7.2
2022.11.12
*/

function hello_dolly_get_lyric() {
	/** These are the lyrics to Hello Dolly */
	$lyrics = "完成比完美更重要。
只有自己诚心待人，别人才有可能对自己以诚相待。
因为你能痛苦，就说明你对生活还抱有希望！
在最平常的事情中都可以显示出一个人人格的伟大来。
在这个世界上，不是所有合理的和美好的都能按照自己的愿望存在或实现。
人之所以痛苦，在于追求错误的东西。
没有人的生活道路是笔直没有岔道的。
人们宁愿去关心一个蹩脚演员的鸡毛蒜皮，也不关心普通人内心的波涛汹涌。
钱当然很重要！但我又觉得，人活一辈子，还应该有些别的什么才对……
小时候，我常常把“亲戚”看得美好和重要，长大才知道亲戚关系的庸俗。
连伟人的一生都充满了艰辛，平凡人吃点苦怎么了。
没有什么一成不变，包括人的关系。
人和人之间的友爱，并不在于是否是亲戚。
生活永远是美好的，人的痛苦却时时在发生……
人处在一种默默奋斗的状态，精神就会从琐碎生活中得到升华。
普通并不等于庸俗。在许许多多普普通通的事情中，应该表现出不平常的看法和做法来。
你知道，幸福不仅仅是吃饱穿暖，而是勇敢的战胜困难。
美丽的花朵凋谢了也是美丽的。
即使没有月亮，心中也是一片皎洁。
什么是人生？人生就是永不休止的奋斗！
每一分钟都有新的生命欣喜地降生到这个世界，同时也把另一些人送进坟墓。这边万里无云，阳光灿烂；那边就可能风云骤起，地裂山崩。世界没有一天是平静的。
命运总是不如愿。但往往是在无数的痛苦中，在重重的矛盾和艰难中，才使人成熟起来，坚强起来；虽然这些东西在实际感受中给人带来的并不都是欢乐。
其实我们每个人的生活都是一个世界，即使最平凡的人也要为他生活的那个世界而奋斗。
人活着，就得随时准备经受磨难。他已经看过一些书，知道不论是普通人还是了不起的人，都要在自己的一生中经历许多磨难。
生活包含着更广阔的意义，而不在于我们实际得到了什么；关键是我们的心灵是否充实。
有了希望，人就会产生激情，并可以义无反顾地为之而付出代价；在这样的过程中，才能真正体会到人生的意义。什么是人生？人生就是永无休止的奋斗！只有决定了目标并在奋斗中，感到自己的努力没有虚掷，这样的生活才是充实的，精神也会永远年轻。";


	// Here we split it into lines.
	$lyrics = explode( "\n", $lyrics );

	// And then randomly choose a line.
	return wptexturize( $lyrics[ mt_rand( 0, count( $lyrics ) - 1 ) ] );
}

// This just echoes the chosen line, we'll position it later.
function hello_dolly() {
	$chosen = hello_dolly_get_lyric();
	$lang   = '';
	if ( 'en_' !== substr( get_user_locale(), 0, 3 ) ) {
		$lang = ' lang="en"';
	}

	printf(
		'<p id="dolly"><span class="screen-reader-text">%s </span><span dir="ltr"%s>%s</span></p>',
		__( 'Quote from Hello Dolly song, by Jerry Herman:', 'hello-dolly' ),
		$lang,
		$chosen
	);
}

// Now we set that function up to execute when the admin_notices action is called.
add_action( 'admin_notices', 'hello_dolly' );

// We need some CSS to position the paragraph.
function dolly_css() {
	echo "
	<style type='text/css'>
	#dolly {
		float: right;
		padding: 5px 10px;
		margin: 0;
		font-size: 12px;
		line-height: 1.6666;
	}
	.rtl #dolly {
		float: left;
	}
	.block-editor-page #dolly {
		display: none;
	}
	@media screen and (max-width: 782px) {
		#dolly,
		.rtl #dolly {
			float: none;
			padding-left: 0;
			padding-right: 0;
		}
	}
	</style>
	";
}

add_action( 'admin_head', 'dolly_css' );
