<?php
/*
Plugin Name: 极简飘雪插件 (Simple Snow Effect)
Plugin URI:  https://yourwebsite.com
Description: 基于 Snowstorm.js 为网站添加优雅的飘雪效果。
Version:     1.0
Author:      Your Name
*/

// 防止直接访问文件
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * 在前台加载飘雪脚本
 */
function mse_enqueue_snow_scripts() {
    // 注册并加载脚本
    wp_enqueue_script( 
        'snowstorm-js', 
        plugins_url( '/snowstorm-min.js', __FILE__ ), 
        array(), 
        '1.44', 
        true 
    );

    // 自定义雪花配置（内联脚本）
    $custom_config = "
        if (typeof snowStorm !== 'undefined') {
            // --- 速度与方向控制 ---
            snowStorm.vMaxX = 0.2;      // 最大横向速度（值越小越垂直）
            snowStorm.vMaxY = 0.6;      // 最大纵向速度（值越小下落越慢）
            snowStorm.vMinX = -0.5;     // 最小横向速度
            snowStorm.vMinY = 0.5;      // 最小纵向速度

            // --- 行为控制 ---
            snowStorm.followMouse = false;   // 关闭鼠标跟随，避免人为干扰“安静”感
            snowStorm.freezeOnBlur = true;   // 页面失去焦点时停止，节省资源
            snowStorm.useMeltEffect = true;  // 允许雪花触底消失，增加轻盈感
            
            // --- 摇摆频率 ---
            // 调低这个值可以让雪花下落时不会左右剧烈晃动
            snowStorm.animationInterval = 40; 
            
            // --- 视觉优化 ---
            snowStorm.snowColor = '#fff';
            snowStorm.flakesMaxActive = 40;  // “安静”的效果通常需要雪花稀疏一点
        }
    ";
    wp_add_inline_script( 'snowstorm-js', $custom_config );
}

add_action( 'wp_enqueue_scripts', 'mse_enqueue_snow_scripts' );