<?php
/**
 * Plugin Name: WP SMTP Mail
 * Plugin URI:  https://wujie.me/
 * Description: 通过SMTP发送邮件的WordPress插件。
 * Version:     1.0
 * Author:      吴杰
 * Author URI:  https://wujie.me/
 * License:     GPL2
 */

// 防止直接访问插件文件
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 设置SMTP配置
define( 'SMTP_HOST', 'smtpdm.aliyun.com' );      // SMTP服务器
define( 'SMTP_PORT', 465 );                     // SMTP端口
define( 'SMTP_USERNAME', 'wordpress@wujie.me' );  // SMTP用户名
define( 'SMTP_PASSWORD', '' ); // SMTP密码
define( 'SMTP_FROM_EMAIL', 'wordpress@wujie.me' ); // 发件人邮箱
define( 'SMTP_FROM_NAME', '慢读时光' );        // 发件人名称

// /**
//  * 强制设置发件人邮箱（必须与SMTP认证账户一致）
//  */
// function wp_custom_smtp_from_email( $email ) {
//     return SMTP_FROM_EMAIL;
// }
// add_filter( 'wp_mail_from', 'wp_custom_smtp_from_email' );

// /**
//  * 强制设置发件人名称
//  */
// function wp_custom_smtp_from_name( $name ) {
//     return SMTP_FROM_NAME;
// }
// add_filter( 'wp_mail_from_name', 'wp_custom_smtp_from_name' );

/**
 * 配置WordPress使用SMTP发送所有邮件
 */
function wp_custom_smtp_mailer( $phpmailer ) {
    $phpmailer->isSMTP();
    $phpmailer->Host       = SMTP_HOST;
    $phpmailer->SMTPAuth   = true;
    $phpmailer->Port       = SMTP_PORT;
    $phpmailer->Username   = SMTP_USERNAME;
    $phpmailer->Password   = SMTP_PASSWORD;
    $phpmailer->SMTPSecure = ( SMTP_PORT == 465 ) ? 'ssl' : 'tls';
    $phpmailer->From       = SMTP_FROM_EMAIL;
    $phpmailer->FromName   = SMTP_FROM_NAME;
    
    // // 启用SMTP调试（调试完成后可以注释掉）
    // $phpmailer->SMTPDebug  = 2; // 0=关闭, 1=客户端消息, 2=客户端和服务器消息
    // $phpmailer->Debugoutput = function($str, $level) {
    //     error_log("SMTP调试 [$level]: $str");
    // };
}
add_action( 'phpmailer_init', 'wp_custom_smtp_mailer' );

// /**
//  * 记录邮件发送成功
//  */
// function wp_custom_smtp_log_success( $mail ) {
//     error_log( sprintf(
//         '[WP SMTP] 邮件发送成功 - 收件人: %s, 主题: %s',
//         is_array( $mail['to'] ) ? implode(', ', $mail['to']) : $mail['to'],
//         $mail['subject']
//     ));
// }
// add_action( 'wp_mail_succeeded', 'wp_custom_smtp_log_success' );

// /**
//  * 记录邮件发送失败
//  */
// function wp_custom_smtp_log_failure( $error ) {
//     error_log( sprintf(
//         '[WP SMTP] 邮件发送失败 - 错误: %s',
//         $error->get_error_message()
//     ));
// }
// add_action( 'wp_mail_failed', 'wp_custom_smtp_log_failure' );

